/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.query.viewer;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import mpi.search.SearchLocale;
import mpi.search.model.SearchListener;
import mpi.search.query.viewer.AbstractSearchPanel;
import mpi.search.query.viewer.StartStopPanel;

public abstract class AbstractSimpleSearchPanel
extends AbstractSearchPanel
implements SearchListener {
    protected Action closeAction;
    protected Action exportAction;
    protected Action startAction;
    protected Action stopAction;
    protected StartStopPanel startStopPanel;

    public AbstractSimpleSearchPanel() {
        this.makeActions();
    }

    public Action getCloseAction() {
        return this.closeAction;
    }

    public Action getExportAction() {
        return this.exportAction;
    }

    public Action getStartAction() {
        return this.startAction;
    }

    @Override
    public void executionStarted() {
        super.executionStarted();
        this.startStopPanel.showStopButton();
        this.updateActions();
    }

    @Override
    public void executionStopped() {
        this.startStopPanel.showStartButton();
        this.updateActions();
    }

    @Override
    public void handleException(Exception e) {
        e.printStackTrace();
        String message = e.getMessage() == null || "".equals(e.getMessage()) ? e.toString() : e.getMessage();
        JOptionPane.showMessageDialog(this, message, SearchLocale.getString("Search.Exception"), 0);
        this.searchEngine.stopExecution();
    }

    protected abstract void export();

    protected void updateActions() {
        boolean executing = this.searchEngine != null && this.searchEngine.isExecuting();
        this.startAction.setEnabled(!executing);
        this.stopAction.setEnabled(executing);
        this.exportAction.setEnabled(!executing && this.searchEngine != null && this.searchEngine.getResult() != null && this.searchEngine.getResult().getRealSize() != 0);
    }

    private void makeActions() {
        this.startAction = new AbstractAction(SearchLocale.getString("Action.Search")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimpleSearchPanel.this.startSearch();
            }
        };
        this.startAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Search"));
        KeyStroke ks = KeyStroke.getKeyStroke(10, 1);
        this.startAction.putValue("AcceleratorKey", ks);
        this.stopAction = new AbstractAction(SearchLocale.getString("Action.Cancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimpleSearchPanel.this.stopSearch();
            }
        };
        this.stopAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Cancel"));
        ks = KeyStroke.getKeyStroke(67, 2);
        this.stopAction.putValue("AcceleratorKey", ks);
        this.exportAction = new AbstractAction(SearchLocale.getString("Action.Export")){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractSimpleSearchPanel.this.export();
            }
        };
        this.exportAction.putValue("ShortDescription", SearchLocale.getString("Action.Tooltip.Export"));
        ks = KeyStroke.getKeyStroke(69, 2);
        this.exportAction.putValue("AcceleratorKey", ks);
    }
}

