/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.result.viewer;

import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class ResultTextPane
extends JTextPane {
    protected final Style regular;
    protected final Style highlighted;

    public ResultTextPane() {
        this.setEditable(false);
        Style defaultStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        this.regular = this.addStyle("regular", defaultStyle);
        this.highlighted = this.addStyle("highlight", this.regular);
    }

    public void appendString(String s) {
        this.insertString(this.getDocument().getLength(), s);
    }

    protected void insertString(int startPosition, String s) {
        try {
            this.getDocument().insertString(startPosition, s, this.regular);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void appendString(String s, int[][] highlights) throws IndexOutOfBoundsException {
        this.insertString(this.getDocument().getLength(), s, highlights);
    }

    protected void insertString(int startPosition, String s, int[][] highlights) {
        block6: {
            if (highlights != null && this.arrayIsConsistent(s, highlights)) {
                try {
                    Document doc = this.getDocument();
                    if (highlights.length > 0) {
                        for (int j = 0; j < highlights.length; ++j) {
                            String substring = s.substring(j == 0 ? 0 : highlights[j - 1][1], highlights[j][0]);
                            doc.insertString(startPosition, substring, this.regular);
                            startPosition += substring.length();
                            substring = s.substring(highlights[j][0], highlights[j][1]);
                            doc.insertString(startPosition, substring, this.highlighted);
                            startPosition += substring.length();
                        }
                        doc.insertString(startPosition, s.substring(highlights[highlights.length - 1][1]), this.regular);
                        break block6;
                    }
                    doc.insertString(startPosition, s, this.regular);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else {
                this.insertString(startPosition, s);
            }
        }
    }

    private boolean arrayIsConsistent(String s, int[][] highlights) {
        for (int j = 0; j < highlights.length; ++j) {
            if (highlights[j][0] >= 0 && highlights[j][0] <= highlights[j][1] && highlights[j][1] <= s.length()) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void setHighlightedBackground(Color color) {
        StyleConstants.setBackground(this.highlighted, color);
    }

    public void setHighlightedForeground(Color color) {
        StyleConstants.setForeground(this.highlighted, color);
    }

    public void setHighlightedBold(boolean b) {
        StyleConstants.setBold(this.highlighted, b);
    }
}

