/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Component;
import java.awt.Dimension;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import nl.mpi.avf.player.AVFBaseMediaPlayer;
import nl.mpi.avf.player.JAVFComponent;
import nl.mpi.avf.player.JAVFImageProducer;
import nl.mpi.avf.player.JAVFPlayer;
import nl.mpi.avf.player.JAVFPlayerException;
import nl.mpi.avf.player.JAVFVideoLoadController;
import nl.mpi.avf.player.JAVFVisualComponent;

public class JAVFMediaPlayer
extends AVFBaseMediaPlayer {
    private JAVFPlayer javfPlayer;
    private JAVFVisualComponent visualComponent;
    private JAVFVideoLoadController videoController;
    private AtomicBoolean playingFlag = new AtomicBoolean();
    private ReentrantLock renderingLock;
    private Condition playingCondition;
    private RenderClockWatcher clockWatcher;

    public JAVFMediaPlayer(String mediaPath) throws JAVFPlayerException {
        super(mediaPath);
    }

    @Override
    void initMediaPlayer() throws JAVFPlayerException {
        try {
            this.avfPlayer = new JAVFPlayer(this.mediaPath);
            this.javfPlayer = (JAVFPlayer)this.avfPlayer;
        }
        catch (JAVFPlayerException je) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(String.format("Cannot create %s, message: %s", JAVFPlayer.class.getName(), je.getMessage()));
            }
            throw je;
        }
        if (this.avfPlayer.hasVideo()) {
            int javfBufferMs;
            block9: {
                this.visualComponent = new JAVFVisualComponent();
                this.visualComponent.setNaturalVideoSize(this.avfPlayer.getOriginalSize());
                String javfBufferLengthProp = System.clearProperty("JAVFPlayer.FrameBufferLengthMS");
                javfBufferMs = -1;
                if (javfBufferLengthProp != null) {
                    try {
                        javfBufferMs = Integer.parseInt(javfBufferLengthProp);
                    }
                    catch (NumberFormatException nfe) {
                        if (!LOG.isLoggable(Level.INFO)) break block9;
                        LOG.info("Invalid value for JAVFPlayer.FrameBufferLengthMS property: " + javfBufferLengthProp);
                    }
                }
            }
            this.videoController = javfBufferMs > 0 ? new JAVFVideoLoadController(this, javfBufferMs) : new JAVFVideoLoadController(this);
            this.renderingLock = new ReentrantLock();
            this.playingCondition = this.renderingLock.newCondition();
            this.clockWatcher = new RenderClockWatcher(5);
            this.clockWatcher.start();
        } else if (LOG.isLoggable(Level.INFO)) {
            LOG.info(String.format("The media file %s has no video track", this.mediaPath));
        }
    }

    @Override
    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public JAVFComponent getVideoComponent() {
        return this.visualComponent;
    }

    @Override
    public void start() {
        if (this.avfPlayer.isPlaying()) {
            return;
        }
        if (this.videoController != null) {
            this.videoController.prepareForPlay(this.avfPlayer.getMediaTime());
            this.playingFlag.set(true);
            this.renderingLock.lock();
            try {
                this.playingCondition.signal();
            }
            finally {
                this.renderingLock.unlock();
            }
        } else {
            this.avfPlayer.start();
        }
    }

    @Override
    public void stop() {
        if (!this.avfPlayer.isPlaying()) {
            return;
        }
        if (this.videoController != null) {
            this.playingFlag.set(false);
        } else {
            this.avfPlayer.stop();
        }
    }

    @Override
    public void setMediaTime(long mediaTimeMS) {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.setMediaTime(mediaTimeMS);
        if (this.videoController != null) {
            this.videoController.timeUpdateMs(mediaTimeMS);
        }
    }

    @Override
    public void setMediaTimeSeconds(double mediaTime) {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.setMediaTimeSeconds(mediaTime);
        if (this.videoController != null) {
            this.videoController.timeUpdateSeconds(mediaTime);
        }
    }

    public boolean setPixelFormatAndImageType(JAVFImageProducer.IMAGE_PRESETS imagePreset) {
        if (this.videoController == null) {
            return false;
        }
        boolean success = false;
        switch (imagePreset) {
            case AV_24RGB_DATABUFFER_BYTE: {
                success = this.javfPlayer.setPixelFormat(JAVFPlayer.AV_PIXEL_FORMAT.AV_24RGB);
                if (!success) break;
                this.videoController.getImageProducer().setImagePreset(JAVFImageProducer.IMAGE_PRESETS.AV_24RGB_DATABUFFER_BYTE);
                break;
            }
            case AV_24RGB_DATABUFFER_INT: {
                success = this.javfPlayer.setPixelFormat(JAVFPlayer.AV_PIXEL_FORMAT.AV_24RGB);
                if (!success) break;
                this.videoController.getImageProducer().setImagePreset(JAVFImageProducer.IMAGE_PRESETS.AV_24RGB_DATABUFFER_INT);
                break;
            }
            case AV_32ARGB_DATABUFFER_BYTE: {
                success = this.javfPlayer.setPixelFormat(JAVFPlayer.AV_PIXEL_FORMAT.AV_32ARGB);
                if (!success) break;
                this.videoController.getImageProducer().setImagePreset(JAVFImageProducer.IMAGE_PRESETS.AV_32ARGB_DATABUFFER_BYTE);
                break;
            }
            case AV_32ARGB_DATABUFFER_INT: {
                success = this.javfPlayer.setPixelFormat(JAVFPlayer.AV_PIXEL_FORMAT.AV_32ARGB);
                if (!success) break;
                this.videoController.getImageProducer().setImagePreset(JAVFImageProducer.IMAGE_PRESETS.AV_32ARGB_DATABUFFER_INT);
                break;
            }
            case AV_32BGRA_DATABUFFER_BYTE: {
                success = this.javfPlayer.setPixelFormat(JAVFPlayer.AV_PIXEL_FORMAT.AV_32BGRA);
                if (!success) break;
                this.videoController.getImageProducer().setImagePreset(JAVFImageProducer.IMAGE_PRESETS.AV_32BGRA_DATABUFFER_BYTE);
                break;
            }
            case AV_32BGRA_DATABUFFER_INT: {
                success = this.javfPlayer.setPixelFormat(JAVFPlayer.AV_PIXEL_FORMAT.AV_32BGRA);
                if (!success) break;
                this.videoController.getImageProducer().setImagePreset(JAVFImageProducer.IMAGE_PRESETS.AV_32BGRA_DATABUFFER_INT);
                break;
            }
        }
        return success;
    }

    @Override
    public void deletePlayer() {
        this.javfPlayer.deletePlayer();
        if (this.clockWatcher != null) {
            this.clockWatcher.interrupt();
            this.clockWatcher = null;
        }
        if (this.videoController != null) {
            this.videoController.close();
            this.videoController = null;
        }
    }

    public int getBytesPerPixel() {
        return this.javfPlayer.getBytesPerPixel();
    }

    public int getBytesPerFrame() {
        return this.javfPlayer.getBytesPerRow() * this.javfPlayer.getVideoImageHeight();
    }

    public int getVideoImageWidth() {
        return this.javfPlayer.getVideoImageWidth();
    }

    public int getVideoImageHeight() {
        return this.javfPlayer.getVideoImageHeight();
    }

    @Override
    public Dimension getOriginalSize() {
        return this.javfPlayer.getOriginalSize();
    }

    public double[] getVideoFrameSequence(long sampleTimeBegin, long sampleTimeEnd, ByteBuffer buffer) {
        return this.javfPlayer.getVideoFrameSequence(sampleTimeBegin, sampleTimeEnd, buffer);
    }

    public double[] getVideoFrameSequenceSeconds(double sampleTimeBegin, double sampleTimeEnd, ByteBuffer buffer) {
        return this.javfPlayer.getVideoFrameSequenceSeconds(sampleTimeBegin, sampleTimeEnd, buffer);
    }

    public String getPixelFormat() {
        return this.javfPlayer.getPixelFormat();
    }

    @Override
    public void setVideoScaleFactor(float scaleFactor) {
        super.setVideoScaleFactor(scaleFactor);
        if (this.visualComponent != null) {
            this.visualComponent.setVideoScaleFactor(scaleFactor);
        }
    }

    @Override
    public void repaintVideo() {
        this.javfPlayer.repaintVideo();
        if (this.visualComponent != null) {
            this.visualComponent.repaint();
        }
    }

    @Override
    public void setVideoBounds(int x, int y, int w, int h) {
        if (this.visualComponent != null) {
            this.visualComponent.setVideoBounds(x, y, w, h);
        }
    }

    @Override
    public int[] getVideoBounds() {
        if (this.visualComponent != null) {
            if (this.getVideoScaleFactor() == 1.0f) {
                return new int[]{0, 0, this.visualComponent.getWidth(), this.visualComponent.getHeight()};
            }
            return this.visualComponent.getVideoBounds();
        }
        return null;
    }

    @Override
    public void moveVideoPos(int dx, int dy) {
        if (this.visualComponent != null && (dx != 0 || dy != 0)) {
            this.visualComponent.moveVideoPosition(dx, dy);
        }
    }

    protected class RenderClockWatcher
    extends Thread {
        private final int SLEEP;
        private double lastTimeSec = 0.0;
        private boolean shouldStopPlayerAtEnd = false;

        public RenderClockWatcher(int sleepTime) {
            this.SLEEP = sleepTime;
        }

        public RenderClockWatcher(int sleepTime, boolean stopPlayerAtEnd) {
            this.SLEEP = sleepTime;
            this.shouldStopPlayerAtEnd = stopPlayerAtEnd;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher start");
            }
            while (!this.isInterrupted()) {
                if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                    AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher not interrupted, acquiring lock");
                }
                JAVFMediaPlayer.this.renderingLock.lock();
                try {
                    if (!JAVFMediaPlayer.this.playingFlag.get()) {
                        if (JAVFMediaPlayer.this.avfPlayer.isPlaying()) {
                            JAVFMediaPlayer.this.avfPlayer.stop();
                            if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                                AVFBaseMediaPlayer.LOG.finest("Stop flagged: " + JAVFMediaPlayer.this.avfPlayer.getMediaTimeSeconds());
                            }
                        }
                        try {
                            if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                                AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher into wait state");
                            }
                            JAVFMediaPlayer.this.playingCondition.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                        AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher entering watch loop");
                    }
                    while (JAVFMediaPlayer.this.playingFlag.get()) {
                        double cts = JAVFMediaPlayer.this.avfPlayer.getMediaTimeSeconds();
                        if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                            AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher current time: " + cts);
                        }
                        if (cts != this.lastTimeSec) {
                            JAVFMediaPlayer.this.videoController.timeUpdateSeconds(cts);
                            this.lastTimeSec = cts;
                        }
                        if (cts == JAVFMediaPlayer.this.avfPlayer.getDurationSeconds()) {
                            if (JAVFMediaPlayer.this.avfPlayer.isPlaying()) {
                                if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                                    AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher end of media time, player isPlaying: " + cts);
                                }
                                if (this.shouldStopPlayerAtEnd) {
                                    JAVFMediaPlayer.this.stop();
                                }
                            } else {
                                if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                                    AVFBaseMediaPlayer.LOG.finest("RenderClockWatcher end of media time player stopped: " + cts);
                                }
                                JAVFMediaPlayer.this.playingFlag.set(false);
                            }
                        }
                        if (!JAVFMediaPlayer.this.avfPlayer.isPlaying() && cts != JAVFMediaPlayer.this.avfPlayer.getDurationSeconds()) {
                            JAVFMediaPlayer.this.avfPlayer.start();
                            if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                                AVFBaseMediaPlayer.LOG.finest("Start time: " + cts);
                            }
                        }
                        try {
                            Thread.sleep(this.SLEEP);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                        AVFBaseMediaPlayer.LOG.finest("Left watch loop");
                    }
                }
                finally {
                    JAVFMediaPlayer.this.renderingLock.unlock();
                }
                if (!AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) continue;
                AVFBaseMediaPlayer.LOG.finest("End of main loop");
            }
            if (AVFBaseMediaPlayer.LOG.isLoggable(Level.FINEST)) {
                AVFBaseMediaPlayer.LOG.finest("End of thread life");
            }
        }
    }
}

