/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.nio.ByteBuffer;
import java.util.logging.Level;
import nl.mpi.avf.player.AVFBasePlayer;
import nl.mpi.avf.player.JAVFPlayerException;

public class JAVFPlayer
extends AVFBasePlayer {
    public JAVFPlayer(String mediaPath) throws JAVFPlayerException {
        super(mediaPath);
        if (this.id > 0L && LOG.isLoggable(Level.FINE)) {
            LOG.fine("Player type: JAVFPlayer - rendering in Java");
        }
    }

    @Override
    public void deletePlayer() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("JAVFPlayer - deleting native resources");
        }
        this.deletePlayer(this.id);
        this.id = -this.id;
    }

    public int getBytesPerRow() {
        return this.getBytesPerRow(this.id);
    }

    public int getBytesPerPixel() {
        return this.getBytesPerPixel(this.id);
    }

    public int getVideoImageWidth() {
        return this.getVideoImageWidth(this.id);
    }

    public int getVideoImageHeight() {
        return this.getVideoImageHeight(this.id);
    }

    public String getPixelFormat() {
        return this.getPixelFormat(this.id);
    }

    public boolean setPixelFormat(AV_PIXEL_FORMAT pixFormat) {
        return this.setPixelFormat(this.id, pixFormat.toString());
    }

    public double[] getVideoFrameSequence(long sampleTimeBegin, long sampleTimeEnd, ByteBuffer buffer) {
        return this.getVideoFrameSequence(this.id, sampleTimeBegin, sampleTimeEnd, buffer);
    }

    public double[] getVideoFrameSequenceSeconds(double sampleTimeBegin, double sampleTimeEnd, ByteBuffer buffer) {
        return this.getVideoFrameSequenceSeconds(this.id, sampleTimeBegin, sampleTimeEnd, buffer);
    }

    @Override
    native long initPlayer(String var1);

    @Override
    native void deletePlayer(long var1);

    private native int getBytesPerRow(long var1);

    private native int getBytesPerPixel(long var1);

    private native int getVideoImageWidth(long var1);

    private native int getVideoImageHeight(long var1);

    private native String getPixelFormat(long var1);

    private native boolean setPixelFormat(long var1, String var3);

    private native double[] getVideoFrameSequence(long var1, long var3, long var5, ByteBuffer var7);

    private native double[] getVideoFrameSequenceSeconds(long var1, double var3, double var5, ByteBuffer var7);

    public static enum AV_PIXEL_FORMAT {
        AV_24RGB,
        AV_32BGRA,
        AV_32ARGB,
        AV_Gray,
        AV_422YpCbCr8;

    }
}

