/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jfx;

import java.awt.Dimension;
import java.awt.Rectangle;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.media.MediaView;

public class JFXVideoPanel
extends JFXPanel {
    private MediaView mediaView;

    public JFXVideoPanel() {
        this.setLayout(null);
    }

    public void setScene(Scene scene) {
        super.setScene(scene);
        if (scene != null) {
            Node node;
            if (scene.getRoot().getChildrenUnmodifiable().size() > 0 && (node = (Node)scene.getRoot().getChildrenUnmodifiable().get(0)) instanceof MediaView) {
                this.mediaView = (MediaView)node;
                this.setMediaViewBounds();
            }
        } else {
            this.mediaView = null;
        }
    }

    private void setMediaViewBounds() {
        if (this.mediaView != null) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JFXVideoPanel.this.mediaView.setX(0.0);
                    JFXVideoPanel.this.mediaView.setY(0.0);
                    JFXVideoPanel.this.mediaView.setFitWidth((double)JFXVideoPanel.this.getWidth());
                    JFXVideoPanel.this.mediaView.setFitHeight((double)JFXVideoPanel.this.getHeight());
                }
            });
        }
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setMediaViewBounds();
    }

    public void setSize(Dimension d) {
        super.setSize(d);
        this.setMediaViewBounds();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setMediaViewBounds();
    }

    public void setBounds(Rectangle r) {
        super.setBounds(r);
        this.setMediaViewBounds();
    }
}

