/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jsound;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class NavigableAudioPlayer
implements Clip {
    private final Logger LOG = Logger.getLogger("JavaSoundMPI");
    private AudioFormat format;
    private SourceDataLine outputDataLine;
    private RandomAccessFile raAudioFile;
    private long headerSizeBytes;
    private DataLine.Info playerInfo;
    private List<LineListener> lineListeners;
    private int frameLengthInt;
    private long frameLength;
    private long microsecondLength;
    private float durationMicroSec = 0.0f;
    private float microSecFrame = 1.0f;
    private int bufferSize = 96000;
    private int frameSize = 1;
    private long microsecondPosition;
    private WriteRun writeRunner;
    private long lastWriteStopFrame;
    private long lastWriteStartFrame;

    public NavigableAudioPlayer(AudioInputStream inputStream, File audioFile, SourceDataLine outputDataLine) throws LineUnavailableException, IOException {
        this.format = inputStream.getFormat();
        this.frameLength = inputStream.getFrameLength();
        this.raAudioFile = new RandomAccessFile(audioFile, "r");
        this.outputDataLine = outputDataLine;
        if (!outputDataLine.isOpen()) {
            outputDataLine.open();
        }
        this.initialize();
    }

    public NavigableAudioPlayer(AudioInputStream inputStream, File audioFile) throws LineUnavailableException, IOException {
        this.format = inputStream.getFormat();
        this.frameLength = inputStream.getFrameLength();
        this.raAudioFile = new RandomAccessFile(audioFile, "r");
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(dataLineInfo)) {
            throw new LineUnavailableException("Line not supported: " + dataLineInfo.toString());
        }
        this.outputDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
        this.outputDataLine.open(this.format);
        this.initialize();
    }

    public NavigableAudioPlayer(File audioFile, AudioFormat format, long dataFrameLength) throws LineUnavailableException, IOException {
        this.format = format;
        this.raAudioFile = new RandomAccessFile(audioFile, "r");
        this.frameLength = dataFrameLength;
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, format);
        if (!AudioSystem.isLineSupported(dataLineInfo)) {
            throw new LineUnavailableException("Line not supported: " + dataLineInfo.toString());
        }
        this.outputDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
        this.outputDataLine.open(format);
        this.initialize();
    }

    private void initialize() throws LineUnavailableException, IOException {
        this.frameSize = this.format.getFrameSize();
        this.frameLengthInt = (int)this.frameLength;
        if (this.format.getFrameRate() != -1.0f) {
            this.durationMicroSec = 1000000.0f * ((float)this.frameLength / this.format.getFrameRate());
            this.bufferSize = (int)((float)this.frameSize * this.format.getFrameRate() * 2.0f);
        } else if (this.format.getSampleRate() != -1.0f) {
            this.durationMicroSec = 1000000.0f * ((float)this.frameLength / this.format.getFrameRate());
            this.bufferSize = (int)((float)this.frameSize * this.format.getSampleRate() * 2.0f);
        } else {
            throw new LineUnavailableException("Cannot determine the duration of the file");
        }
        this.microsecondLength = (long)this.durationMicroSec;
        this.microSecFrame = 1000000.0f / this.format.getFrameRate();
        this.headerSizeBytes = this.raAudioFile.length() - this.frameLength * (long)this.frameSize;
        this.raAudioFile.seek(this.headerSizeBytes);
        this.lineListeners = new ArrayList<LineListener>();
    }

    private long framesToBytes(long frames) {
        return frames * (long)this.frameSize;
    }

    private long microsecondsToBytes(long microseconds) {
        return (long)((float)microseconds / this.microSecFrame) * (long)this.frameSize;
    }

    private long framesToMicroseconds(long frames) {
        return (long)((float)frames * this.microSecFrame);
    }

    private long microsecondsToFrames(long microseconds) {
        return (long)((float)microseconds / this.microSecFrame);
    }

    @Override
    public void drain() {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        this.outputDataLine.drain();
    }

    @Override
    public void flush() {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        this.outputDataLine.flush();
    }

    @Override
    public void start() {
        if (!this.outputDataLine.isRunning()) {
            this.lastWriteStartFrame = this.outputDataLine.getLongFramePosition();
            this.outputDataLine.start();
            this.writeRunner = new WriteRun(this.bufferSize);
            new Thread(this.writeRunner).start();
            this.postLineEvent(new LineEvent(this, LineEvent.Type.START, this.microsecondsToFrames(this.microsecondPosition)));
        }
    }

    @Override
    public void stop() {
        if (this.outputDataLine.isRunning()) {
            if (this.writeRunner != null) {
                this.writeRunner.stopWriting();
            }
            this.outputDataLine.stop();
            this.lastWriteStopFrame = this.outputDataLine.getLongFramePosition();
            this.setMicrosecondPosition(this.microsecondPosition + this.framesToMicroseconds(this.lastWriteStopFrame - this.lastWriteStartFrame));
            this.postLineEvent(new LineEvent(this, LineEvent.Type.STOP, this.microsecondsToFrames(this.microsecondPosition)));
        }
    }

    @Override
    public boolean isRunning() {
        return this.outputDataLine.isRunning();
    }

    @Override
    public boolean isActive() {
        return this.outputDataLine.isActive();
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public int getFramePosition() {
        return (int)this.microsecondsToFrames(this.getMicrosecondPosition());
    }

    @Override
    public long getLongFramePosition() {
        return this.microsecondsToFrames(this.getMicrosecondPosition());
    }

    @Override
    public long getMicrosecondPosition() {
        if (this.outputDataLine.isRunning()) {
            long deltaF = this.outputDataLine.getLongFramePosition() - this.lastWriteStartFrame;
            return this.microsecondPosition + this.framesToMicroseconds(deltaF);
        }
        return this.microsecondPosition;
    }

    @Override
    public float getLevel() {
        return 1.0f;
    }

    @Override
    public Line.Info getLineInfo() {
        if (this.playerInfo == null) {
            this.playerInfo = new DataLine.Info(this.getClass(), this.format);
        }
        return this.playerInfo;
    }

    @Override
    public void open() throws LineUnavailableException {
        if (!this.outputDataLine.isOpen()) {
            this.outputDataLine.open();
        }
        this.postLineEvent(new LineEvent(this, LineEvent.Type.OPEN, 0L));
    }

    @Override
    public void close() {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        if (this.outputDataLine.isOpen()) {
            this.outputDataLine.close();
        }
        try {
            this.raAudioFile.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.postLineEvent(new LineEvent(this, LineEvent.Type.CLOSE, 0L));
    }

    @Override
    public boolean isOpen() {
        return this.outputDataLine.isOpen();
    }

    @Override
    public Control[] getControls() {
        return this.outputDataLine.getControls();
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return this.outputDataLine.isControlSupported(control);
    }

    @Override
    public Control getControl(Control.Type control) {
        return this.outputDataLine.getControl(control);
    }

    @Override
    public synchronized void addLineListener(LineListener listener) {
        if (!this.lineListeners.contains(listener)) {
            this.lineListeners.add(listener);
        }
    }

    @Override
    public synchronized void removeLineListener(LineListener listener) {
        this.lineListeners.remove(listener);
    }

    private void postLineEvent(LineEvent event) {
        for (LineListener listener : this.lineListeners) {
            listener.update(event);
        }
    }

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        throw new LineUnavailableException("Method not supported");
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
        throw new LineUnavailableException("Method not supported, use one of the constructors to open this player");
    }

    @Override
    public int getFrameLength() {
        return this.frameLengthInt;
    }

    public long getFrameLengthLong() {
        return this.frameLength;
    }

    @Override
    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    @Override
    public void setFramePosition(int frames) {
        this.setPosition(this.framesToBytes(frames));
        this.microsecondPosition = this.framesToMicroseconds(frames);
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        this.microsecondPosition = microseconds;
        this.setPosition(this.microsecondsToBytes(microseconds));
    }

    private void setPosition(long bytePosition) {
        block4: {
            if (this.outputDataLine.isRunning()) {
                this.outputDataLine.stop();
            }
            this.outputDataLine.flush();
            if (bytePosition % (long)this.frameSize != 0L) {
                bytePosition -= bytePosition % (long)this.frameSize;
            }
            try {
                this.raAudioFile.seek(this.headerSizeBytes + bytePosition);
            }
            catch (IOException ioe) {
                if (!this.LOG.isLoggable(Level.WARNING)) break block4;
                this.LOG.warning("Cannot seek position: " + ioe.getMessage());
            }
        }
    }

    @Override
    public void setLoopPoints(int start, int end) {
    }

    @Override
    public void loop(int count) {
    }

    private void endOfMedia() {
        long baseFrame = this.microsecondsToFrames(this.microsecondPosition);
        while (this.outputDataLine.isRunning()) {
            if (baseFrame + (this.outputDataLine.getLongFramePosition() - this.lastWriteStartFrame) >= this.frameLength - 1L) {
                this.stop();
                break;
            }
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.postLineEvent(new LineEvent(this, LineEvent.Type.STOP, this.frameLength));
    }

    private class WriteRun
    implements Runnable {
        byte[] buffer;
        boolean stopWritingRequested = false;

        public WriteRun(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }

        void stopWriting() {
            this.stopWritingRequested = true;
        }

        @Override
        public void run() {
            while (!this.stopWritingRequested) {
                try {
                    int written;
                    int readBytes = NavigableAudioPlayer.this.raAudioFile.read(this.buffer, 0, this.buffer.length);
                    if (readBytes < NavigableAudioPlayer.this.frameSize) {
                        NavigableAudioPlayer.this.endOfMedia();
                        break;
                    }
                    if (this.stopWritingRequested || (written = NavigableAudioPlayer.this.outputDataLine.write(this.buffer, 0, readBytes)) > 0) continue;
                }
                catch (IOException ioe) {
                    if (!NavigableAudioPlayer.this.LOG.isLoggable(Level.WARNING)) break;
                    NavigableAudioPlayer.this.LOG.warning("Unable to read or write audio data: " + ioe.getMessage());
                }
                break;
            }
        }
    }
}

