/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jsound;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class StreamingPlayer
implements Clip {
    private AudioInputStream inputStream;
    private AudioFormat format;
    private SourceDataLine outputDataLine;
    private int frameLengthInt;
    private long microsecondLength;
    private float durationMicroSec = 0.0f;
    private float microSecFrame = 1.0f;
    private int bufferSize = 96000;
    private int frameSize = 1;
    private long microsecondPosition;
    private WriteRun writeRunner;
    private long lastWriteStopFrame;
    private long lastWriteStartFrame;

    public StreamingPlayer(AudioInputStream inputStream, SourceDataLine outputDataLine) throws LineUnavailableException {
        this.inputStream = inputStream;
        this.format = inputStream.getFormat();
        this.outputDataLine = outputDataLine;
        if (!outputDataLine.isOpen()) {
            outputDataLine.open();
        }
        this.initialize();
    }

    public StreamingPlayer(AudioInputStream inputStream) throws LineUnavailableException {
        this.inputStream = inputStream;
        this.format = inputStream.getFormat();
        DataLine.Info dataLineInfo = new DataLine.Info(SourceDataLine.class, this.format);
        if (!AudioSystem.isLineSupported(dataLineInfo)) {
            throw new LineUnavailableException("Line not supported: " + dataLineInfo.toString());
        }
        this.outputDataLine = (SourceDataLine)AudioSystem.getLine(dataLineInfo);
        this.outputDataLine.open(this.format);
        this.initialize();
    }

    private void initialize() throws LineUnavailableException {
        this.frameSize = this.format.getFrameSize();
        this.frameLengthInt = (int)this.inputStream.getFrameLength();
        if (this.format.getFrameRate() != -1.0f) {
            this.durationMicroSec = 1000000.0f * ((float)this.inputStream.getFrameLength() / this.format.getFrameRate());
            this.bufferSize = (int)((float)this.frameSize * this.format.getFrameRate() * 2.0f);
        } else if (this.format.getSampleRate() != -1.0f) {
            this.durationMicroSec = 1000000.0f * ((float)this.inputStream.getFrameLength() / this.format.getFrameRate());
            this.bufferSize = (int)((float)this.frameSize * this.format.getSampleRate() * 2.0f);
        } else {
            throw new LineUnavailableException("Cannot determine the duration of the file");
        }
        this.microsecondLength = (long)this.durationMicroSec;
        this.microSecFrame = 1000000.0f / this.format.getFrameRate();
        this.inputStream.mark(this.frameLengthInt * this.frameSize);
    }

    private long framesToBytes(long frames) {
        return frames * (long)this.frameSize;
    }

    private long microsecondsToBytes(long microseconds) {
        return (long)((float)microseconds / this.microSecFrame) * (long)this.frameSize;
    }

    private long framesToMicroseconds(long frames) {
        return (long)((float)frames * this.microSecFrame);
    }

    private long microsecondsToFrames(long microseconds) {
        return (long)((float)microseconds / this.microSecFrame);
    }

    @Override
    public void drain() {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        this.outputDataLine.drain();
    }

    @Override
    public void flush() {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        this.outputDataLine.flush();
    }

    @Override
    public void start() {
        if (!this.outputDataLine.isRunning()) {
            this.lastWriteStartFrame = this.outputDataLine.getLongFramePosition();
            this.outputDataLine.start();
            this.writeRunner = new WriteRun(this.bufferSize);
            new Thread(this.writeRunner).start();
        }
    }

    @Override
    public void stop() {
        if (this.outputDataLine.isRunning()) {
            if (this.writeRunner != null) {
                this.writeRunner.stopWriting();
            }
            this.outputDataLine.stop();
            this.lastWriteStopFrame = this.outputDataLine.getLongFramePosition();
            this.setMicrosecondPosition(this.microsecondPosition + this.framesToMicroseconds(this.lastWriteStopFrame - this.lastWriteStartFrame));
        }
    }

    @Override
    public boolean isRunning() {
        return this.outputDataLine.isRunning();
    }

    @Override
    public boolean isActive() {
        return this.outputDataLine.isActive();
    }

    @Override
    public AudioFormat getFormat() {
        return this.format;
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public int available() {
        return 0;
    }

    @Override
    public int getFramePosition() {
        return (int)this.microsecondsToFrames(this.getMicrosecondPosition());
    }

    @Override
    public long getLongFramePosition() {
        return this.microsecondsToFrames(this.getMicrosecondPosition());
    }

    @Override
    public long getMicrosecondPosition() {
        if (this.outputDataLine.isRunning()) {
            long deltaF = this.outputDataLine.getLongFramePosition() - this.lastWriteStartFrame;
            return this.microsecondPosition + this.framesToMicroseconds(deltaF);
        }
        return this.microsecondPosition;
    }

    @Override
    public float getLevel() {
        return 1.0f;
    }

    @Override
    public Line.Info getLineInfo() {
        return null;
    }

    @Override
    public void open() throws LineUnavailableException {
        if (!this.outputDataLine.isOpen()) {
            this.outputDataLine.open();
        }
    }

    @Override
    public void close() {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        if (this.outputDataLine.isOpen()) {
            this.outputDataLine.close();
        }
    }

    @Override
    public boolean isOpen() {
        return this.outputDataLine.isOpen();
    }

    @Override
    public Control[] getControls() {
        return this.outputDataLine.getControls();
    }

    @Override
    public boolean isControlSupported(Control.Type control) {
        return this.outputDataLine.isControlSupported(control);
    }

    @Override
    public Control getControl(Control.Type control) {
        return this.outputDataLine.getControl(control);
    }

    @Override
    public void addLineListener(LineListener listener) {
        this.outputDataLine.addLineListener(listener);
    }

    @Override
    public void removeLineListener(LineListener listener) {
        this.outputDataLine.removeLineListener(listener);
    }

    @Override
    public void open(AudioFormat format, byte[] data, int offset, int bufferSize) throws LineUnavailableException {
        throw new LineUnavailableException("Unsupported");
    }

    @Override
    public void open(AudioInputStream stream) throws LineUnavailableException, IOException {
    }

    @Override
    public int getFrameLength() {
        return this.frameLengthInt;
    }

    public long getFrameLengthLong() {
        return this.inputStream.getFrameLength();
    }

    @Override
    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    @Override
    public void setFramePosition(int frames) {
        this.setPosition(this.framesToBytes(frames));
        this.microsecondPosition = this.framesToMicroseconds(frames);
    }

    @Override
    public void setMicrosecondPosition(long microseconds) {
        this.microsecondPosition = microseconds;
        this.setPosition(this.microsecondsToBytes(microseconds));
    }

    private void setPosition(long bytePosition) {
        if (this.outputDataLine.isRunning()) {
            this.outputDataLine.stop();
        }
        this.outputDataLine.flush();
        if (bytePosition % (long)this.frameSize != 0L) {
            bytePosition -= bytePosition % (long)this.frameSize;
        }
        try {
            long nextSkip;
            this.inputStream.reset();
            long startSampleByte = bytePosition;
            for (long skipped = this.inputStream.skip(startSampleByte); skipped < startSampleByte; skipped += nextSkip) {
                long nextReq = startSampleByte - skipped;
                nextSkip = this.inputStream.skip(nextReq);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    @Override
    public void setLoopPoints(int start, int end) {
    }

    @Override
    public void loop(int count) {
    }

    private class WriteRun
    implements Runnable {
        byte[] buffer;
        boolean stopWritingRequested = false;

        public WriteRun(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }

        void stopWriting() {
            this.stopWritingRequested = true;
        }

        @Override
        public void run() {
            while (!this.stopWritingRequested) {
                try {
                    int written;
                    int readBytes = StreamingPlayer.this.inputStream.read(this.buffer, 0, this.buffer.length);
                    if (readBytes < StreamingPlayer.this.frameSize) break;
                    if (this.stopWritingRequested || (written = StreamingPlayer.this.outputDataLine.write(this.buffer, 0, readBytes)) > 0) continue;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                break;
            }
        }
    }
}

