/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LocaleUtil {
    public static void main(String[] args) {
        block7: {
            try {
                if (args.length == 2) {
                    LocaleUtil.sortPropertiesFiles(Path.of(args[0], new String[0]), args[1], null, 2);
                    break block7;
                }
                if (args.length == 3) {
                    LocaleUtil.sortPropertiesFiles(Path.of(args[0], new String[0]), args[1], Path.of(args[2], new String[0]), 2);
                    break block7;
                }
                if (args.length >= 4) {
                    int numDots = 2;
                    try {
                        numDots = Integer.parseInt(args[3]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    LocaleUtil.sortPropertiesFiles(Path.of(args[0], new String[0]), args[1], Path.of(args[2], new String[0]), numDots);
                    break block7;
                }
                System.out.println("At least specify a source/base directory and a qualified name of a properties file");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static StringBuffer sort(ResourceBundle bundle, int groupPerNumDots) {
        ArrayList<String> keyList = new ArrayList<String>(bundle.keySet());
        Collections.sort(keyList);
        LinkedHashMap linkedKeyMap = new LinkedHashMap();
        for (String key : keyList) {
            String[] parts = key.split("\\.", groupPerNumDots + 1);
            int actualNumDots = Math.min(groupPerNumDots, parts.length - 1);
            String prefix = parts[0];
            for (int i = 1; i < actualNumDots; ++i) {
                prefix = String.join((CharSequence)".", prefix, parts[i]);
            }
            if (linkedKeyMap.containsKey(prefix)) {
                ((List)linkedKeyMap.get(prefix)).add(key);
                continue;
            }
            ArrayList<String> curGroup = new ArrayList<String>();
            curGroup.add(key);
            linkedKeyMap.put(prefix, curGroup);
        }
        StringBuffer sb = new StringBuffer();
        String space = " ";
        String lineSep = "\r\n";
        for (String key : linkedKeyMap.keySet()) {
            List group = (List)linkedKeyMap.get(key);
            int keyLength = 0;
            for (String k : group) {
                keyLength = Math.max(keyLength, k.length());
            }
            ++keyLength;
            for (String k : group) {
                sb.append(k);
                sb.append(" ".repeat(keyLength - k.length()));
                sb.append("= ");
                sb.append(bundle.getString(k).replaceAll("\n", "\\\\n"));
                sb.append("\r\n");
            }
            sb.append("\r\n");
        }
        return sb;
    }

    public static void sortPropertiesFiles(Path basePath, String resBaseName, Path baseOutPath, int groupPerNumDots) throws IOException {
        String resourceName = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_PROPERTIES).toResourceName(resBaseName, "properties");
        Path inputPath = Path.of(basePath.toString(), resourceName);
        Path absOutputPath = null;
        boolean overwrite = basePath.equals(baseOutPath);
        if (baseOutPath != null) {
            absOutputPath = !overwrite ? Path.of(baseOutPath.toString(), inputPath.getFileName().toString()) : inputPath;
        }
        LocaleUtil.sortPropertiesFile(inputPath, absOutputPath, groupPerNumDots);
        Path parentPath = inputPath.getParent();
        String inFileName = inputPath.getFileName().toString();
        int dotIndex = inFileName.lastIndexOf(46);
        String filePat = inFileName.substring(0, dotIndex) + "_[a-zA-Z_]*" + inFileName.substring(dotIndex);
        if (parentPath != null) {
            String[] fileNames;
            for (String fileName : fileNames = parentPath.toFile().list()) {
                if (!fileName.matches(filePat)) continue;
                Path nextInPath = Path.of(parentPath.toString(), fileName);
                Path nextOutPath = null;
                if (baseOutPath != null) {
                    nextOutPath = !overwrite ? Path.of(baseOutPath.toString(), fileName) : nextInPath;
                }
                LocaleUtil.sortPropertiesFile(nextInPath, nextOutPath, groupPerNumDots);
            }
        }
    }

    public static void sortPropertiesFile(Path absInPath, Path absOutPath, int groupPerNumDots) throws IOException {
        PropertyResourceBundle bundle = new PropertyResourceBundle(Files.newInputStream(absInPath, StandardOpenOption.READ));
        StringBuffer sb = LocaleUtil.sort(bundle, groupPerNumDots);
        if (sb == null) {
            System.out.println("No sorted strings returned (null)");
            return;
        }
        if (absOutPath != null) {
            BufferedWriter bw = null;
            try {
                bw = Files.newBufferedWriter(absOutPath, Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                bw.write(sb.toString());
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Throwable thr) {
                throw new IOException(thr);
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        System.out.println(sb.toString());
    }
}

